#!/usr/bin/env bash
SOURCE="$0"

while [ -h "$SOURCE"  ]; do
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
	  # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE"
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

function help() {
  echo "Supported Options:"
  echo "    -h|--help                   show this message."
  echo "    -i|--install_prefix <path> specify install prefix."
  echo "    -k|--key_bin        <path> specify key bin filepath."
  echo ""
}

args=("$@")
KEY_BIN=""
INSTALL_DIR=/usr/local
while (( "$#" )); do
  case "$1" in
    -i|--install_prefix)
      # if next arg is not option.
      if [[ "#$2" != "#-"* ]]; then
        # make sure that the arg is not empty.
        if [ "#$2" != "#" ]; then
          INSTALL_DIR=$2
          shift 2
          continue
        fi
      fi
      # 没有参数，使用默认安装路径
      shift 1
      ;;
    -k|--key-bin)
      # if next arg is not option.
      if [[ "#$2" != "#-"* ]]; then
        # make sure that the arg is not empty.
        if [ "#$2" != "#" ]; then
          KEY_BIN=$2
          shift 2
          continue
        fi
      fi
      # without arg, using default
      shift 1
      ;;
    -h|--help)
      help
      eixt 0
    ;;
    --) # end argument parsing
      shift
      break
      ;;
    -*|--*=) # unsupported flags
      echo "Error: Unsupported options $1" >&2
      exit 1
      ;;
    *) # preserve positional arguments
      PARAMS="$PARAMS $1"
      shift
      ;;
  esac
done

if [ "#$INSTALL_DIR" = "#" ]; then
  INSTALL_DIR=/usr/local
fi

if [ "#$KEY_BIN" != "#" ] && [ ! -f $KEY_BIN ] ; then
  echo "key bin: $KEY_BIN, no such file."
fi

chmod +x *.sh
for bin in ospshell-cli eis-cli upgrad-cli upgrade-rules sniperknl-crontab scanner-cli sniper-flag-tool
do
  [ -f ${bin} ] && chmod +x ${bin}
done

# 停止当前正在运行的客户端
if [ -f /usr/local/sniper/sniper ] ; then
  /usr/local/sniper/shutdown.sh force
fi

# 检查客户端是否已经安装，如果已经安装则先将客户端备份到 /tmp目录下
if [ -d /usr/local/sniper ] ; then
  mkdir -p /tmp/install_backup
  cp -r /usr/local/sniper/ /tmp/install_backup/

  # 安装新版本客户端，如果安装失败，则删除/tmp下的备份，如果成功，将 /tmp下的备份转移到安装目录进行备份，如：/usr/local/sniper.old
  # 执行升级卸载
  /usr/local/sniper/uninstall.sh upgrade 1> /dev/null

  # 安装新版本客户端
  ./pure-install.sh "${args[@]}"
  # TODO 判断安装是否成功
  OLD_SNIPER_DIR="$INSTALL_DIR/sniper.old"

  # 备份旧的备份
  if [ -d $OLD_SNIPER_DIR ] ; then
    rm -rf $OLD_SNIPER_DIR.${DATE}
    mv $OLD_SNIPER_DIR $OLD_SNIPER_DIR.${DATE}
  fi

  #if [ -L $OLD_SNIPER_DIR ]; then
  #  rm -rf $OLD_SNIPER_DIR
  #fi

  # 临时备份转移成正式的版本备份
  mv /tmp/install_backup/sniper $OLD_SNIPER_DIR
  rm -rf /tmp/install_backup/

  # 发送当前版本客户端卸载命令到服务端中
  cd $OLD_SNIPER_DIR && $OLD_SNIPER_DIR/sniper -o uninstall
  cd ${DIR}

  # 还原配置文件，例如 .file_server_address whitelist.rc config/.data_reducer.config config/key.bin
  for config in .file_server_address whitelist.rc config/.data_reducer.config config/key.bin custom_rules
  do
    if [ -f "$OLD_SNIPER_DIR/${config}" ] || [ -d "$OLD_SNIPER_DIR/${config}" ] ; then
      echo "copy $config to $INSTALL_DIR/sniper"
      cp -r "$OLD_SNIPER_DIR/${config}" "$INSTALL_DIR/sniper/$(dirname ${config})"
    fi
  done
  # 删除更老的版本
  if [ -d "$OLD_SNIPER_DIR.${DATE}" ] ; then
    rm -rf "$OLD_SNIPER_DIR.${DATE}"
  fi

  if [ "#${KEY_BIN}" != "#" ] && [ -f "${KEY_BIN}" ] ; then
    echo "copy the ${KEY_BIN} to the dir $INSTALL_DIR/sniper/config"
    $INSTALL_DIR/sniper/regist.sh "${KEY_BIN}"
  fi
else
  ./pure-install.sh "${args[@]}"
fi

# 安装客户端补丁包
if [ -f patch/install.sh ] ; then
  chmod +x patch/install.sh
  ./patch/install.sh
fi

echo "please using 'sniper-start' to startup the client manually!!!"
