#!/usr/bin/env bash
SOURCE="$0"

while [ -h "$SOURCE"  ]; do 
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
	# if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE" 
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

# 强制停止应用层进程
function force_stop() {
    sniper_pid=`ps -ef | grep sniper | grep -v $0 | grep -v sniperknl | grep -v grep | grep -v .sniper_tmp | awk '{print $2}'`
    kill -9 ${sniper_pid}
}

OP=$1

# 停止应用层探针服务
if [ -f /usr/local/sniper/sniper ] ; then
    cd ${DIR}

    # 针对升级和卸载做不同处理，卸载需要上报卸载时间到服务端
    if [ "#$OP" != "#upgrade" ] ; then
        /usr/local/sniper/sniper -o uninstall
    else
        /usr/local/sniper/sniper -o stop
    fi

    if [ 0 != $? ] ; then
        cd -
        logger "[sniper] stoped sniper agent failed"
        echo "=> stoped sniper agent failed!!!"
        force_stop
        sleep 3
    fi
    cd -
else
    echo "=> /usr/local/sbin/sniper-stop and /usr/local/sniper/sniper No such file or directory"
fi

logger "[sniper] uninstall sniper kernel module"

# 停止驱动模块
echo "=> uninstall sniper kernel module"
is_driver_installed=`lsmod | grep sniper | wc -l`
if [ "${is_driver_installed}" != "0" ] ; then 
    logger "[sniper] rmmod sniperknl"
    sleep 3 
    rmmod sniperknl
    # 如果卸载驱动失败时，强制停止应用层，并再次卸载驱动
    if [ 0 != $? ] ; then 
        logger "[sniper] force stop"
        force_stop
        sleep 3
        rmmod sniperknl
    fi
fi

logger "[sniper] uninstall system service config file"
# 如果使用的systemctl管理sniper服务，则将服务从自启动服务列表中移除
echo "=> uninstall system service config file"
type systemctl >/dev/null 2>&1 && { systemctl disable sniper.service 2> /dev/null; rm -rf /usr/lib/systemd/system/sniper.service; }
rm -rf /etc/init.d/sniper

echo "=> unregister sniperknl logger"
if [ -f /usr/local/sniper/patch/uninstall.sh ] ; then
    chmod +x /usr/local/sniper/patch/uninstall.sh
    /usr/local/sniper/patch/uninstall.sh
fi

echo "=> uninstall pam config file"
rm -rf /etc/pam.d/chkpasswd-nerv
rm -rf /etc/pam.d/chkpasswd-onescorpion

echo "=> remove sniper service config files"
rm -rf /etc/.edr.pid
rm -rf /etc/.edr.daemon.pid
rm -rf /etc/.edr.install.date
if [ -L /usr/local/sniper ]; then
  rm -rf "$(readlink /usr/local/sniper)"
fi
rm -rf /usr/local/sniper

echo "=> remove sniper service scripts"
rm -rf /usr/local/sbin/sniper-start
rm -rf /usr/local/sbin/sniper-stop
rm -rf /usr/local/sbin/sniper-uninstall
rm -rf /usr/local/sbin/sniper-regist
rm -rf /usr/local/sbin/sniper-register
rm -rf /usr/local/sbin/sniper-ctl

echo "=> uninstall succeeded, bye bye!!!"
