#!/usr/bin/env bash
SOURCE="$0"

while [ -h "$SOURCE"  ]; do 
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
	# if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE" 
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

KEYBIN=$1

echo "=> install sniper pam service ..."
if [ -d /etc/pam.d/ ] && [ -f $DIR/chkpasswd-nerv ] ; then
    cp $DIR/chkpasswd-nerv /etc/pam.d/
fi

echo "=> install sniper into system service ..."
system_infos=`cat /etc/issue 2> /dev/null`
redhat_version=`cat /etc/redhat-release 2> /dev/null`
cgs_version=`cat /etc/system-release 2> /dev/null`

function like() {
    local match_result=`echo "$1" | grep "$2" | wc -l | awk '{print $1}'`
    [ "$match_result" == "1" ]
}

echo "=> install sniper into dir '/usr/local/sniper'"
rm -rf /usr/local/sniper
cp -r $DIR /usr/local/sniper

chmod +x /usr/local/sniper/sniper 2> /dev/null
chmod +x /usr/local/sniper/upgrade 2> /dev/null
chmod +x /usr/local/sniper/*.sh 2> /dev/null

function install_service() {
    echo "=> install service"
    cp service-template /etc/init.d/sniper
    chmod +x /etc/init.d/sniper
    chkconfig --add sniper
    chkconfig --level 2345 sniper on
}

function install_service_for_ubuntu_1404() {
    echo "=> install service for ubuntu 14.04"
    cp service-template /etc/init.d/sniper
    chmod +x /etc/init.d/sniper
    update-rc.d sniper defaults
}

function install_systemd_service() {
    echo "=> install systemd.service"
    mkdir -p /usr/lib/systemd/system/
    cp systemctl-template /usr/lib/systemd/system/sniper.service
    chmod +x /usr/lib/systemd/system/sniper.service
    systemctl daemon-reexec
    systemctl enable sniper.service
}

if like "$system_infos" "Ubuntu" && (like "$system_infos" "16\.04" || like "$system_infos" "18\.04") ; then
    echo "=> install service into ubuntu systemctl"
    install_systemd_service
elif (like "$system_infos" "Ubuntu" && like "$system_infos" "14\.04") || (like "$system_infos" "Ubuntu" && like "$system_infos" "12\.") ; then
    echo "=> install service into ubuntu service"
    install_service_for_ubuntu_1404
elif like "$system_infos" "CentOS" &&  (like "$system_infos" "5\." || like "$system_infos" "6\.") ; then
    echo "=> install service into centos (5/6) service"
    install_service
elif (like "$system_infos" "Red Hat Enterprise Linux Server release" && like "$system_infos" "6\.") || (like "$redhat_version" "Red Hat Enterprise Linux Server release" && like "$redhat_version" "6\."); then
    echo "=> install service into redhat service"
    install_service
elif (like "$system_infos" "CentOS" && (like "$system_infos" "7\." || like "$system_infos" "8\.")) || (like "$redhat_version" "CentOS" && (like "$redhat_version" "7\." || like "$redhat_version" "8\.")) ; then
    echo "=> install service into centos (7/8) systemctl"
    install_systemd_service
elif (like "$system_infos" "Red Hat Enterprise Linux Server release" && like "$system_infos" "7\.") || (like "$redhat_version" "Red Hat Enterprise Linux Server release" && like "$redhat_version" "7\."); then
    echo "=> install service into centos7 systemctl"
    install_systemd_service
elif (like "$system_infos" "Kylin" && like "$system_infos" "3\.") || (like "$redhat_version" "Kylin" && like "$redhat_version" "3\.") ; then
    echo "=> install service into Kylin 3 service"
    install_service
elif like "$system_infos" "SUSE" ; then
    echo "=> install service into ubuntu service"
    install_systemd_service
elif like "$system_infos" "Debian" ; then
    echo "=> install service into debian systemctl"
    install_systemd_service
elif like "$cgs_version" "NeoKylin" ; then
    echo "=> install service into NeoKylin systemctl"
    install_systemd_service
elif like "$cgs_version" "NewStart NSDL release V3.3" ;  then
    echo "=> install service into NewStart NSDL release V3.3.* failed, unsported os version"
    exit -1
elif like "$cgs_version" "NewStart Carrier Grade Server Linux release 4." ;  then
    echo "=> install service into NewStart Carrier Grade Server Linux release 4.*"
    install_service
elif like "$cgs_version" "NewStart Carrier Grade Server Linux release 5." ;  then
    echo "=> install service into NewStart Carrier Grade Server Linux release 5.*"
    install_systemd_service
else
    echo "=> unsported os version, install failed!!!"
    echo "/etc/issue:\n$system_infos"
    echo "/etc/redhat-release:\n$redhat_version"
    ./uninstall.sh
    exit -1
fi

# 配置rsyslog日志，对sniperknl模块日志进行过滤以及归档
function config_sniperknl_log() {
	chmod 0644 sniperknl-logrotate
    mkdir -p /etc/rsyslog.d/ /etc/logrotate.d/
    cp sniperknl-rsyslog.conf /etc/rsyslog.d/
    cp sniperknl-logrotate /etc/logrotate.d/
    service rsyslog restart
}

# 配置内核模块日志
if like "$system_infos" "CentOS" && like "$system_infos" "6\."; then
    config_sniperknl_log
elif like "$system_infos" "Red Hat Enterprise Linux Server release" || (like "$redhat_version" "Red Hat Enterprise Linux Server release" && like "$redhat_version" "6\.") ; then
    config_sniperknl_log
else
    echo "sniperknl log record into the system log file '/var/log/messages'"
fi 

# 安装服务脚本
echo "=> install service scripts to /usr/local/sbin"
mkdir -p /usr/local/sbin/
if [ -f /usr/local/sniper/startup.sh ] ; then 
    ln -sf /usr/local/sniper/startup.sh /usr/local/sbin/sniper-start
fi 

if [ -f /usr/local/sniper/shutdown.sh ] ; then 
    ln -sf /usr/local/sniper/shutdown.sh /usr/local/sbin/sniper-stop
fi

if [ -f /usr/local/sniper/uninstall.sh ] ; then 
    ln -sf /usr/local/sniper/uninstall.sh /usr/local/sbin/sniper-uninstall
fi 

if [ -f /usr/local/sniper/register.sh ] ; then
    ln -sf /usr/local/sniper/register.sh /usr/local/sbin/sniper-regist
    ln -sf /usr/local/sniper/register.sh /usr/local/sbin/sniper-register
fi

if [ -f /usr/local/sniper/sniper-ctl.sh ] ; then
    ln -sf /usr/local/sniper/sniper-ctl.sh /usr/local/sbin/sniper-ctl
fi

# 清除安装后的文件中存在的不必要文件
find /usr/local/sniper -name "._*" | xargs -n 1 rm -f

# 检查环境变量，如果不存在则设置环境变量，避免upgrade在启动是，不能发现启动问题
echo $PATH | grep -q "/usr/local/sbin/"
if [ $? -ne 0 ]; then
  echo 'export PATH=$PATH:/usr/local/sbin/' >> /etc/profile
  source /etc/profile
fi

# 检查当前安装安装包路径是否存在 key.bin 文件或者安装时指定 key.bin 所在的路径文件是否存在，如果存在则安装该key.bin
if [ "#${KEYBIN}" != "#" ] && [ -f ${KEYBIN} ] ; then
    echo "copy the ${KEYBIN} to the dir /usr/local/sniper/config"
    /usr/local/sniper/register.sh ${KEYBIN}
fi

echo "=> sniper installed, you need to manually restart the sniper, or restart the system, thanks!!!"

