#!/usr/bin/env sh

DATE=$(date +%Y%m%d)

# 创建报告目录
mkdir -p report-${DATE}

# 采集系统日志文件
echo "<= system logs"
tar -czvf - /var/log/messages* /var/log/secure* /var/log/dmesg* 2> /dev/null | split -d -b 500m - report-${DATE}/system-logs.tar.gz

# 采集应用层日志文件
echo "<= application logs <="
tar -czvf - /usr/local/sniper/logs 2> /dev/null | split -d -b 500m - report-${DATE}/sniper-logs.tar.gz

# 如果客户端有coredump采集dump文件
dump_file=`ls -S /usr/local/sniper/core* 2> /dev/null | head -1`
if [ ! -z $dump_file ] ; then
    echo "<= application coredump file:" ${dump_file}
    tar -czvf - $dump_file 2> /dev/null | split -d -b 500m - report-${DATE}/sniper-coredupm.tar.gz
fi

# 采集客户端版本信息
echo "<= application version"
cp /usr/local/sniper/version.json report-${DATE}/ 2> /dev/null

# 采集驱动层日志文件
echo "<= driver logs"
tar -czvf - /var/log/sniperknl* 2> /dev/null | split -d -b 500m - report-${DATE}/driver-logs.tar.gz

# 采集系统crash信息
echo "<= crash info"
if [ -d /var/crash ] ; then
    tar -czvf - /var/crash 2> /dev/null | split -d -b 500m - report-${DATE}/crash.tar.gz
fi

# 采集系统版本信息
echo "<= system info"
cp /etc/issue report-${DATE}/
cp /etc/redhat-release report-${DATE}/

echo "Please pass the dir[report-${DATE}}] to the developer"
